/*
 * Decompiled with CFR 0.152.
 */
package com.tp_link.eap.monitor.backup.impl;

import com.tp_link.eap.domain.scheduler.AutoBackupSchedule;
import com.tp_link.eap.domain.scheduler.Schedule;
import com.tp_link.eap.domain.scheduler.bean.AutoBackupFile;
import com.tp_link.eap.domain.scheduler.bean.TaskType;
import com.tp_link.eap.domain.ui.Grid;
import com.tp_link.eap.domain.ui.QueryData;
import com.tp_link.eap.monitor.backup.a;
import com.tp_link.eap.monitor.backup.b;
import com.tp_link.eap.monitor.backup.c;
import com.tp_link.eap.monitor.task.repo.ScheduleRepository;
import com.tp_link.eap.multicontrol.ControlType;
import com.tp_link.eap.multicontrol.OperationResponse;
import com.tp_link.eap.multicontrol.ResErrorCode;
import com.tp_link.eap.util.e;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component(value="autoBackupService")
public class AutoBackupServiceImpl
implements a {
    private static final Logger a = LoggerFactory.getLogger(AutoBackupServiceImpl.class);
    private static final String b = "autobackup";
    private static final int c = 1024;
    private Pattern d = Pattern.compile("^autobackup_(((7|30|60|90|180|365)days)|SettingsOnly|AllTime)_[0-9]{4}((0[1-9])|(1[0-2]))((0[1-9])|((1|2)[0-9])|30|31)_(((0|1)[0-9])|(2[0-3]))(([0-5])([0-9]))\\.cfg$");
    @Autowired
    private ScheduleRepository e;
    @Autowired
    private com.tp_link.eap.monitor.task.service.a f;
    @Autowired
    private b g;
    @Autowired
    @Qualifier(value="restoreService")
    private c h;
    @Autowired
    private com.tp_link.eap.monitor.cloudkey.service.a i;

    @Override
    public void a() {
        Throwable throwable;
        List<AutoBackupFile> list;
        String string;
        a.debug("Start to auto backup");
        AutoBackupSchedule autoBackupSchedule = (AutoBackupSchedule)this.e.findByScheduleType(TaskType.AutoBackup.name());
        String string2 = this.i.getAutoBackupFileSavingPath(autoBackupSchedule.getSavingPath());
        if (StringUtils.isEmpty((Object)string2)) {
            a.warn("Auto backup default path is null");
            return;
        }
        int n2 = autoBackupSchedule.getRetention();
        switch (n2) {
            case -1: {
                string = "SettingsOnly";
                break;
            }
            case 0: {
                string = "AllTime";
                break;
            }
            case 1: {
                string = n2 + "day";
                break;
            }
            default: {
                string = n2 + "days";
            }
        }
        long l2 = System.currentTimeMillis();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd_HHmm");
        String string3 = simpleDateFormat.format(l2);
        String string4 = string2 + File.separator + b + "_" + string + "_" + string3 + ".cfg";
        a.debug("File name is {}", (Object)string4);
        File file = new File(string4);
        try {
            list = new FileOutputStream(file);
            throwable = null;
            try {
                this.g.a((OutputStream)((Object)list), n2, l2);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (list != null) {
                    if (throwable != null) {
                        try {
                            ((OutputStream)((Object)list)).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((OutputStream)((Object)list)).close();
                    }
                }
            }
        }
        catch (IOException iOException) {
            a.error(iOException.toString(), (Throwable)iOException);
        }
        if (null == autoBackupSchedule.getMaxNoOfFiles()) {
            a.warn("Auto backup maximum file number is null");
            return;
        }
        list = this.d(string2);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            while (list.size() > autoBackupSchedule.getMaxNoOfFiles()) {
                throwable = (AutoBackupFile)list.get(list.size() - 1);
                this.c(string2 + File.separator + throwable.getFileName());
                list.remove(list.size() - 1);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public OperationResponse restoreAutoBackupFile(ControlType controlType, JSONObject reqObj) {
        if (com.tp_link.eap.util.m.b.n()) {
            return new OperationResponse(ResErrorCode.cj);
        }
        JSONObject jSONObject = reqObj.optJSONObject("params");
        String string = jSONObject.optString("fileName");
        if (StringUtils.isEmpty((Object)string)) {
            a.debug("Auto backup file name is empty");
            return new OperationResponse(ResErrorCode.d);
        }
        AutoBackupSchedule autoBackupSchedule = (AutoBackupSchedule)this.e.findByScheduleType(TaskType.AutoBackup.name());
        if (null == autoBackupSchedule || !autoBackupSchedule.isEnable()) {
            a.warn("AutoBackup Schedule is null or not enabled");
            return new OperationResponse(ResErrorCode.bp);
        }
        String string2 = this.i.getAutoBackupFileSavingPath(autoBackupSchedule.getSavingPath());
        if (StringUtils.isEmpty((Object)string2)) {
            a.warn("Auto backup default path is null");
            return new OperationResponse(ResErrorCode.b);
        }
        File file = new File(string2 + File.separator + string);
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            OperationResponse operationResponse = this.h.a(fileInputStream);
            return operationResponse;
        }
        catch (IOException iOException) {
            a.error("Restore from file {} error, file illegal or not exist", (Object)string);
            return new OperationResponse(ResErrorCode.bp);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public OperationResponse exportAutoBackupFile(HttpServletResponse response, ControlType controlType, JSONObject reqObj) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public OperationResponse deleteAutoBackupFile(ControlType controlType, JSONObject reqObj) {
        if (com.tp_link.eap.util.m.b.n()) {
            return new OperationResponse(ResErrorCode.cj);
        }
        JSONObject jSONObject = reqObj.optJSONObject("params");
        String string = jSONObject.optString("fileName");
        if (StringUtils.isEmpty((Object)string)) {
            a.debug("Auto backup file name is empty");
            return new OperationResponse(ResErrorCode.d);
        }
        AutoBackupSchedule autoBackupSchedule = (AutoBackupSchedule)this.e.findByScheduleType(TaskType.AutoBackup.name());
        if (null == autoBackupSchedule || !autoBackupSchedule.isEnable()) {
            a.warn("AutoBackup Schedule is null or not enabled");
            return new OperationResponse(ResErrorCode.b);
        }
        String string2 = this.i.getAutoBackupFileSavingPath(autoBackupSchedule.getSavingPath());
        if (StringUtils.isEmpty((Object)string2)) {
            a.warn("Auto backup default path is null");
            return new OperationResponse(ResErrorCode.b);
        }
        return this.c(string2 + File.separator + string);
    }

    @Override
    public OperationResponse getGridAutoBackupFiles(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (null == jSONObject) {
            a.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        QueryData queryData = (QueryData)JSONObject.toBean((JSONObject)jSONObject, QueryData.class);
        Grid grid = new Grid(queryData);
        AutoBackupSchedule autoBackupSchedule = (AutoBackupSchedule)this.e.findByScheduleType(TaskType.AutoBackup.name());
        if (null == autoBackupSchedule || !autoBackupSchedule.isEnable()) {
            grid.setTotalRows(0L);
            grid.setData(new ArrayList());
            return new OperationResponse(ResErrorCode.a, (Object)grid);
        }
        String string = this.i.getAutoBackupFileSavingPath(autoBackupSchedule.getSavingPath());
        if (StringUtils.isEmpty((Object)string)) {
            a.warn("Auto backup default path is null");
            autoBackupSchedule.setEnable(false);
            this.f.refreshSchedule((Schedule)autoBackupSchedule);
            grid.setTotalRows(0L);
            grid.setData(new ArrayList());
            return new OperationResponse(ResErrorCode.a, (Object)grid);
        }
        List<AutoBackupFile> list = this.d(string);
        if (!CollectionUtils.isEmpty(list)) {
            int n2 = queryData.getCurrentPage();
            int n3 = queryData.getCurrentPageSize();
            int n4 = (n2 - 1) * n3;
            int n5 = n2 * n3;
            if (n5 > list.size()) {
                n5 = list.size();
            }
            grid.setTotalRows((long)list.size());
            grid.setData(list.subList(n4, n5));
        } else {
            grid.setTotalRows(0L);
            grid.setData(new ArrayList());
        }
        return new OperationResponse(ResErrorCode.a, (Object)grid);
    }

    private String a(String string) {
        String string2 = string.substring(0, string.lastIndexOf(46));
        String[] stringArray = string2.split("_");
        String string3 = stringArray[2];
        String string4 = stringArray[3];
        String string5 = string3.substring(0, 4);
        String string6 = string3.substring(4, 6);
        String string7 = string3.substring(6, 8);
        String string8 = string4.substring(0, 2);
        String string9 = string4.substring(2, 4);
        return string6 + "/" + string7 + "/" + string5 + " " + string8 + ":" + string9;
    }

    private Long b(String string) {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm");
            return simpleDateFormat.parse(string).getTime();
        }
        catch (Exception exception) {
            a.error("Parse date format {} error", (Object)string);
            return 0L;
        }
    }

    private String a(long l2) {
        DecimalFormat decimalFormat = new DecimalFormat("#,###");
        if (l2 < 1024L) {
            return decimalFormat.format(l2) + " B";
        }
        l2 = Math.round((double)l2 / 1024.0);
        return decimalFormat.format(l2) + " KB";
    }

    private OperationResponse c(String string) {
        if (StringUtils.isEmpty((Object)string)) {
            a.debug("Auto backup file is empty");
            return new OperationResponse(ResErrorCode.bA);
        }
        File file = new File(string);
        if (file.delete()) {
            a.info("Delete auto backup file {} succeed.", (Object)string);
        } else {
            a.warn("Can not delete auto backup file {} ", (Object)string);
        }
        return com.tp_link.eap.util.e.bd;
    }

    private List<AutoBackupFile> d(String string) {
        File file = new File(string);
        ArrayList<AutoBackupFile> arrayList = new ArrayList<AutoBackupFile>();
        if (file.exists() && file.isDirectory()) {
            String[] stringArray = file.list();
            if (null == stringArray) {
                return arrayList;
            }
            for (String string2 : stringArray) {
                Matcher matcher;
                if (StringUtils.isEmpty((Object)string2) || !(matcher = this.d.matcher(string2)).matches()) continue;
                a.debug("Filename {} is valid", (Object)string2);
                File file2 = new File(string + File.separator + string2);
                AutoBackupFile autoBackupFile = new AutoBackupFile();
                autoBackupFile.setFileName(string2);
                autoBackupFile.setSize(this.a(file2.length()));
                autoBackupFile.setBackupTime(this.a(string2));
                autoBackupFile.setTimeStamp(this.b(autoBackupFile.getBackupTime()));
                arrayList.add(autoBackupFile);
            }
        }
        Collections.sort(arrayList, Collections.reverseOrder());
        return arrayList;
    }
}

